package com.zerovalueentertainment.errors;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/**
 * 
 * @author ZeroValueEntertainment
 *
 */
public class Errors {
	private String error = "";
	private JFrame sParent = null;
	
	/**
	 * Initialize the class with no options
	 */
	public Errors(){}
	
	/**
	 * Initialize the class with a starting error message
	 * @param initialErrorMessage
	 */
	public Errors(String initialErrorMessage){
		add(initialErrorMessage);
	}
	
	/**
	 * Initialize the class with a starting error message and auto display the message if autoDisplay=true
	 * @param initialErrorMessage
	 * @param autoDisplay
	 */
	public Errors(String initialErrorMessage, boolean autoDisplay){
		add(initialErrorMessage);
		if(autoDisplay)
			display();
	}
	
	/**
	 * Initialize the class with a starting error message and auto display the message if autoDisplay=true
	 * using parent as the parent JFrame
	 * @param initialErrorMessage
	 * @param autoDisplay
	 * @param parent
	 */
	public Errors(String initialErrorMessage, boolean autoDisplay, JFrame parent){
		add(initialErrorMessage);
		this.sParent = parent;
		if(autoDisplay)
			display(parent);
	}
	
	/**
	 * Add an error message to be displayed when display() is called
	 * @param error
	 * @return the Object so the add command can be chained
	 */
	public Errors add(String error){
		if(this.error.isEmpty())
			this.error = error;
		else
			this.error += "\n" + error;
		return this;
	}
	
	/**
	 * Have any errors been added?
	 * @return True is an error has been added, False otherwise
	 */
	public boolean hasError(){
		return(!error.isEmpty());
	}
	
	/**
	 * Set the parent JFrame
	 * @param parent
	 * @return
	 */
	public Errors setParent(JFrame parent){
		this.sParent = parent;
		return this;
	}

	/**
	 * Display the error dialog using parent if it has been set.
	 */
	public Errors display(){
		if(hasError())
			JOptionPane.showMessageDialog(sParent, error);
		return this;
	}
	
	/**
	 * Display the error dialog using parent
	 * @param parent
	 */
	public void display(JFrame parent){
		this.sParent = parent;
		if(hasError())
			JOptionPane.showMessageDialog(sParent, error);
	}
	
	/**
	 * Get a string representation of all errors that have been added. Newline(\n) separated.
	 * @return
	 */
	public String getErrors(){
		return this.error;
	}
}
